---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：82-Spark Connect JDBCクライアント

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **トランザクション制御の詳細**：auto-commit以外の具体的な動作は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/connect/client/jdbc/src/main/java/org/apache/spark/sql/connect/client/jdbc/SparkConnectDriver.java` 23-31行目
- E-02: `sql/connect/client/jdbc/src/main/scala/org/apache/spark/sql/connect/client/jdbc/NonRegisteringSparkConnectDriver.scala` 27-49行目
- E-03: `sql/connect/client/jdbc/src/main/scala/org/apache/spark/sql/connect/client/jdbc/SparkConnectConnection.scala` 29-80行目
- E-04: `sql/connect/client/jdbc/src/main/scala/org/apache/spark/sql/connect/client/jdbc/SparkConnectStatement.scala`
- E-05: `sql/connect/client/jdbc/src/main/scala/org/apache/spark/sql/connect/client/jdbc/SparkConnectResultSet.scala`
- E-06: `sql/connect/client/jdbc/src/main/scala/org/apache/spark/sql/connect/client/jdbc/SparkConnectDatabaseMetaData.scala`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` 82行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | staticブロックでDriverManagerに自動登録 | E-01 | ○ |
| C-02 | jdbc:sc://形式のURLのみ受け付ける | E-02 (29行目) | ○ |
| C-03 | URLがnullの場合SQLExceptionをスロー | E-02 (33行目) | ○ |
| C-04 | SparkConnectClientを内部的に構築する | E-03 (31-36行目) | ○ |
| C-05 | SparkSessionを構築して保持する | E-03 (38行目) | ○ |
| C-06 | closedフラグで接続状態を管理する | E-03 (40行目) | ○ |
| C-07 | checkOpen()で接続・セッション有効性を検証 | E-03 (51-58行目) | ○ |
| C-08 | setCatalogでカタログ切り替え | E-03 (62-65行目) | ○ |
| C-09 | setSchemaでデータベース切り替え | E-03 (72-75行目) | ○ |
| C-10 | jdbcCompliant()はfalseを返す | E-02 (46行目) | ○ |
| C-11 | getParentLoggerは未サポート例外をスロー | E-02 (48行目) | ○ |
| C-12 | MajorVersionをSPARK_VERSIONから算出 | E-02 (42-44行目) | ○ |
| C-13 | jdbc:プレフィックス除去してconnectionStringに渡す | E-03 (35行目) | ○ |
| C-14 | isValid()で接続有効性とセッション有効性を確認 | E-03 (60行目) | ○ |
| C-15 | close()でSparkSession.close()を呼び出し | E-03 (44-49行目) | ○ |
| C-16 | auto-commit設定のサポート | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- auto-commitおよびトランザクション制御の具体的な実装状況
  - 候補：SparkConnectConnectionのautoCommit関連メソッド / Spark SQLのトランザクション仕様

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - JDBC標準インターフェースの実装はソースコードから明確に確認可能
- 1: 中リスク - JDBC準拠度の正確な範囲（サポートされるメソッド/されないメソッド）の詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] SparkConnectConnectionの全JDBCメソッドの実装状況を確認
- [ ] BIツールとの接続互換性テスト結果を確認
- [ ] トランザクション関連メソッドの動作を確認
